/*
 *  $Id: create_send.c,v 1.8 1994/06/07 21:22:07 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   creat_s.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@
    MPI_Send_init - Builds a handle for a standard send

Input Parameters:
. buf - initial address of send buffer (choice) 
. count - number of elements sent (integer) 
. datatype - type of each element (handle) 
. dest - rank of destination (integer) 
. tag - message tag (integer) 
. comm - communicator (handle) 
Output Parameter:
. request - communication request (handle) 
@*/
Int MPI_Send_init( void far *buf, Int count, MPI_Datatype datatype, Int dest,
					Int tag, MPI_Comm comm, MPI_Request far *request)
{
    Int         errno;
    MPI_Request handleptr;

    if (MPIR_TEST_COMM(comm,comm) || MPIR_TEST_COUNT(comm,count) ||
	MPIR_TEST_DATATYPE(comm,datatype) || MPIR_TEST_SEND_TAG(comm,tag) ||
	MPIR_TEST_SEND_RANK(comm,dest)) 
	return MPIR_ERROR(comm, errno, "Error in MPI_SEND_INIT" );

    *request                        = 
	(MPI_Request) MPIR_SBalloc( MPIR_shandles );
    handleptr                       = *request;
    handleptr->type                 = MPIR_SEND;
    if (dest == MPI_PROC_NULL)
	handleptr->shandle.dest     = dest;
    else
	handleptr->shandle.dest     = comm->group->lrank_to_grank[dest];
    handleptr->shandle.tag          = tag;
    handleptr->shandle.contextid    = comm->send_context;
    handleptr->shandle.lrank        = 
	comm->local_group->lrank_to_grank[comm->local_group->local_rank];
    handleptr->shandle.mode         = MPIR_MODE_STANDARD;
    handleptr->shandle.datatype     = datatype;
    handleptr->shandle.bufadd       = buf;
    handleptr->shandle.count        = count;
    handleptr->shandle.completed    = MPIR_NO;
    handleptr->shandle.persistent   = 1;
    handleptr->shandle.active       = 0;
    
    MPID_alloc_send_handle(&((handleptr)->shandle.dev_shandle));
    MPID_set_send_is_nonblocking( &((handleptr)->shandle.dev_shandle), 1 );

    return MPI_SUCCESS;
}
