/*
 *  $Id
 *
 *  (C) 1994 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   initrecv.c                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: initrecv.c,v 1.2 1994/06/07 21:22:11 gropp Exp $";
#endif /* lint */

/* This initializes the fields of a request structure */

Int MPIR_Recv_init( void far *buf, Int count, MPI_Datatype datatype, Int source, 
					Int tag, MPI_Comm comm, MPI_Request request, Int nonblocking)
{
    request->type                 = MPIR_RECV;
    if (source == MPI_ANY_SOURCE)
		request->rhandle.source   = source;
    else
		request->rhandle.source   = comm->group->lrank_to_grank[source];

    request->rhandle.tag          = tag;
    request->rhandle.contextid    = comm->recv_context;
    request->rhandle.datatype     = datatype;
    request->rhandle.bufadd       = buf;
    request->rhandle.count        = count;
    request->rhandle.completed    = 0;
    MPID_alloc_recv_handle(&((request)->rhandle.dev_rhandle));
    MPID_set_recv_is_nonblocking( &((request)->rhandle.dev_rhandle), 
				 nonblocking );

/* WIN : return value fixed */	
	return MPI_SUCCESS;

}
