/*
 *  $Id: iprobe.c,v 1.3 1994/06/07 21:22:13 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   iprobe.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop


#ifndef lint
static char vcid[] = "$Id: ";
#endif /* lint */

/*@
    MPI_Iprobe - Nonblocking test for a message

Input Parameters:
. source - source rank, or  MPI_ANY_SOURCE (integer) 
. tag - tag value or  MPI_ANY_TAG (integer) 
. comm - communicator (handle) 

Output Parameter:
. flag - (logical) 
. status - status object (Status) 

@*/
Int MPI_Iprobe( Int source, Int tag, MPI_Comm comm, Int far *flag, MPI_Status far *status)
{
    Int errno;
    if (MPIR_TEST_COMM(comm,comm) || MPIR_TEST_RECV_TAG(comm,tag) ||
		MPIR_TEST_RECV_RANK(comm,source))
	{		
		return MPIR_ERROR( comm, errno, "Error in MPI_PROBE" );
	}

    MPID_iprobe( tag, source, comm->recv_context, flag, status );
    return MPI_SUCCESS;
}
