/*
 *  $Id: start.c,v 1.11 1994/06/07 21:22:26 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   start.c                                                            *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: start.c,v 1.11 1994/06/07 21:22:26 gropp Exp $";
#endif /* lint */

/* NOTES 
   We mark all sends and receives as non-blocking because that is safe here;
   unfortunately, we don't have enough information in the current send/recv
   handle to determine if we are blocking or not.
 */

/*@
    MPI_Start - Initiates a communication with a persistent request handle

Input Parameter:
. request - communication request (handle) 

@*/
Int MPI_Start( MPI_Request far *request)
{
    Int is_available;
    Int errno = MPI_SUCCESS;
    MPIR_SHANDLE far *shandle;
    MPIR_RHANDLE far *rhandle;

    if (MPIR_TEST_REQUEST(MPI_COMM_WORLD,*request))
		return MPIR_ERROR(MPI_COMM_WORLD, errno, "Error in MPI_START" );

    /* See also send.c */
    if ((*request)->type == MPIR_SEND)
    {
        shandle = &(*request)->shandle;
		if (shandle->dest == MPI_PROC_NULL) 
			return errno;
		shandle->active       = 1;
		if (shandle->datatype->is_contig) 
		{
		    shandle->dev_shandle.start = shandle->bufadd;
	        shandle->dev_shandle.bytes_as_contig =
						shandle->count * shandle->datatype->extent;
		    shandle->bufpos                      = 0;
	    }
#ifdef MPID_PACK_IN_ADVANCE
		else 
		{
		    if ((errno = MPIR_PackMessage( shandle->bufadd, shandle->count, 
							shandle->datatype, shandle->dest, *request )) != 0)
			{
				MPIR_ERROR( MPI_COMM_WORLD, errno, 
					    "Could not pack message in MPI_START" );
			}
	    }
#else
		else 
		{
		    shandle->dev_shandle.start = 0;
	    }
#endif

		/* device will post the send */
		MPID_post_send( &((*request)->shandle) );
    }
    else if ((*request)->type == MPIR_RECV)
    {
        rhandle = &(*request)->rhandle;
		if (rhandle->source == MPI_PROC_NULL) 
			return errno;
		
		rhandle->active       = 1;
		if (rhandle->datatype->is_contig) 
		{
		    rhandle->dev_rhandle.start = rhandle->bufadd;
	        rhandle->dev_rhandle.bytes_as_contig =
		     			rhandle->count * rhandle->datatype->extent;
		    rhandle->bufpos                      = 0;
	    }
#ifdef MPID_RETURN_PACKED
		else 
		{
		    if ((errno = MPIR_SetupUnPackMessage( 
		    				rhandle->bufadd, rhandle->count, 
							rhandle->datatype, rhandle->source, *request )) != 0)
			{
				MPIR_ERROR( MPI_COMM_WORLD, errno, 
					   "Could not pack message in MPI_START" );
			}
	    }
#else
		else 
		    rhandle->dev_rhandle.start = 0;
#endif
        /* device will handle queueing of MPIR recv handle in posted-recv 
	   queue         
	 */
        MPID_set_recv_is_nonblocking( &(rhandle->dev_rhandle), 1 );
		MPID_post_recv( rhandle, &(is_available) );
    }
    else
		errno = MPIR_ERROR(MPI_COMM_WORLD,MPI_ERR_INTERN,
			   "bad request type in MPI_START");

    return errno;
}


