/*
 *  $Id: testany.c,v 1.16 1994/06/07 21:22:29 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   testany.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@
    MPI_Testany - Tests for completion of any previdously initiated 
                  communication

Input Parameters:
. count - list length (integer) 
. array_of_requests - array of requests (array of handles) 

Output Parameters:
. index - index of operation that completed, or MPI_UNDEFINED  if none 
  completed (integer) 
. flag - true if one of the operations is complete (logical) 
. status - status object (Status) 
@*/
Int MPI_Testany( Int count, MPI_Request far *array_of_requests, 
				 Int far *index, Int far *flag, MPI_Status far *status)
{
    Int i, found;
//    Int errno;
    MPI_Request request;

    *index = MPI_UNDEFINED;

    /* Check for the trivial case of nothing to do. */
    for (i=0; i<count; i++) 
    {
		if (array_of_requests[i] && array_of_requests[i]->chandle.active) 
		    break;
	}
    if (i == count) 
    	return MPI_SUCCESS;

    MPID_check_device( 0 );
    found = 0;
    for (i = 0; i < count; i++)
    {
        request = array_of_requests[i];
		if ( !request  || !request->chandle.active ) 
			continue;

	  	if ( request->chandle.completed == MPIR_YES) 
	  	{
		    found         = 1;
		    *index        = i;
		    if ( request->type == MPIR_SEND ) 
		    {
				MPID_complete_send( &request->shandle, status );
		    }
		    else 
		    {
				MPID_complete_recv( &request->rhandle );
		
				status->MPI_SOURCE     = request->rhandle.source;
				status->MPI_TAG	       = request->rhandle.tag;
				status->count	       = request->rhandle.actcount;
				status->count_in_bytes = request->rhandle.totallen;
		    }

		    if (!request->chandle.persistent) 
		    {
				MPI_Request_free( &array_of_requests[i] );
				array_of_requests[i]    = NULL;
			}
		    else 
		    {
				request->chandle.active	= 0;
				request->chandle.completed	= MPIR_NO;
				if (request->type == MPIR_RECV) 
				{
				    MPID_reuse_recv_handle( &request->rhandle.dev_rhandle );
				}
				else 
				{
				    MPID_reuse_send_handle( &request->shandle.dev_shandle );
				}
			}
			break;
        }
    }

    *flag = found;

    return MPI_SUCCESS;
}

