/*
 *  $Id: testsome.c,v 1.7 1994/06/07 21:22:31 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   testsom.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: testsome.c,v 1.7 1994/06/07 21:22:31 gropp Exp $";
#endif /* lint */

/*@
    MPI_Testsome - Tests for some given communications to complete

Input Parameters:
. incount - length of array_of_requests (integer) 
. array_of_requests - array of requests (array of handles) 

Output Parameters:
. outcount - number of completed requests (integer) 
. array_of_indices - array of indices of operations that 
completed (array of integers) 
. array_of_statuses - array of status objects for 
    operations that completed (array of Status) 
@*/
Int MPI_Testsome( Int incount, MPI_Request far *array_of_requests, Int far *outcount, 
			Int far *array_of_indices, MPI_Status far *array_of_statuses )
{
    Int i;
//    MPIR_BOOL completed;
    Int nfound = 0;
    MPI_Request request;

    /* NOTE:
       This implementation will not work correctly if the device requires
       messages to be received in some particular order.  In that case, 
       this routine needs to try and complete the messages in ANY order.
       
       The same is true for testall.c .
     */
    MPID_check_device( MPID_NOTBLOCKING );
    for (i = 0; i < incount; i++)
	{
	/* Skip over null handles.  We need this for handles generated
	   when MPI_PROC_NULL is the source or destination of an 
	   operation */
	request = array_of_requests[i];

	if (!request || !request->chandle.active) continue;

	if (request->chandle.completed) {
	    
	    array_of_indices[nfound++] = i;
	    if ( request->type == MPIR_RECV )
		{
		MPID_complete_recv( &request->rhandle );
		
		array_of_statuses[i].MPI_SOURCE = 
		    request->rhandle.source;
		array_of_statuses[i].MPI_TAG    = 
		    request->rhandle.tag;
		array_of_statuses[i].count  = 
		    request->rhandle.actcount;  
		array_of_statuses[i].count_in_bytes =
		    request->rhandle.totallen;
		
		}
	    else 
		MPID_complete_send( &request->shandle, 
				   &(array_of_statuses[i]) );
	    
	    if (!request->chandle.persistent) {
		MPI_Request_free( &array_of_requests[i] ); 
		array_of_requests[i]    = NULL;
		}
	    else {
		request->chandle.active	= 0;
		request->chandle.completed	= MPIR_NO;
		if (request->type == MPIR_RECV) {
		    MPID_reuse_recv_handle( &request->rhandle.dev_rhandle );
		    }
		else {
		    MPID_reuse_send_handle( &request->shandle.dev_shandle );
		    }
		} 
	    }
	}
    *outcount = nfound;
    return MPI_SUCCESS;
}
