/*
 *  $Id: type_contig.c,v 1.6 1994/06/13 18:08:44 doss Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   type_cn.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: type_contig.c,v 1.6 1994/06/13 18:08:44 doss Exp $";
#endif /* lint */

/*@
    MPI_Type_contiguous - Creates a contiguous datatype

Input Parameters:
. count - replication count (nonnegative integer) 
. oldtype - old datatype (handle) 

Output Parameter:
. newtype - new datatype (handle) 

@*/
Int MPI_Type_contiguous( Int count, MPI_Datatype old_type, MPI_Datatype far *newtype)
{
  MPI_Datatype  dteptr;
  Int errno = MPI_SUCCESS;

  /* Check for bad arguments */
  if ( MPIR_TEST_DATATYPE(MPI_COMM_WORLD,old_type) ||
   ( (old_type == (*newtype))        && ((errno = MPI_ERR_TYPE) != 0) )  ||
   ( (count   <= 0)                  && ((errno = MPI_ERR_COUNT) != 0) ) ||
   ( (old_type->dte_type == MPIR_UB) && ((errno = MPI_ERR_TYPE) != 0) )  ||
   ( (old_type->dte_type == MPIR_LB) && ((errno = MPI_ERR_TYPE) != 0) ) )
	return MPIR_ERROR( MPI_COMM_WORLD, errno,
					  "Error in MPI_TYPE_CONTIGUOUS" );
	
  /* Create and fill in the datatype */
  dteptr = (*newtype) = (MPI_Datatype) MPIR_SBalloc( MPIR_dtes );
  dteptr->dte_type    = MPIR_CONTIG;
  dteptr->committed   = MPIR_FALSE;
  dteptr->basic       = MPIR_FALSE;
  dteptr->permanent   = MPIR_FALSE;
  dteptr->ref_count   = 1;
  dteptr->align       = old_type->align;
  dteptr->stride      = 1;
  dteptr->blocklen    = 1;
  dteptr->is_contig   = old_type->is_contig;
  dteptr->elements    = count * old_type->elements;

  /* Take care of contiguous vs non-contiguous case */
  if (old_type->is_contig) {
	dteptr->old_type  = (MPI_Datatype)MPIR_Type_dup (old_type->old_type);
	dteptr->count     = count * old_type->count;
	dteptr->pad       = 0;
  }
  else {
	dteptr->old_type  = (MPI_Datatype)MPIR_Type_dup (old_type);
	dteptr->count     = count;
	dteptr->pad       = ((old_type->align -
             (old_type->size % old_type->align)) % old_type->align);
  }

  /* Set the upper/lower bounds and the extent and size */
  dteptr->lb          = dteptr->old_type->lb;
  dteptr->extent      = dteptr->count * dteptr->old_type->extent;
  dteptr->ub          = dteptr->lb + dteptr->extent;
  dteptr->size        = (dteptr->count * dteptr->old_type->size) +
	                    ((dteptr->count - 1) * dteptr->pad);
  
  return (errno);
}
