/*
 *  $Id: type_size.c,v 1.3 1994/06/07 21:22:39 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   type_sz.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: type_size.c,v 1.3 1994/06/07 21:22:39 gropp Exp $";
#endif /* lint */

/*@
    MPI_Type_size - Return the number of bytes occupied by entries
                    in the datatype

Input Parameters:
. datatype - datatype (handle) 

Output Parameter:
. size - datatype size (integer) 
@*/
Int MPI_Type_size ( MPI_Datatype  datatype, MPI_Aint far *size)
{
  Int errno;
  if (MPIR_TEST_DATATYPE(MPI_COMM_WORLD,datatype) || MPIR_TEST_ARG(size))
	return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_TYPE_SIZE" );

  /* Assign the size and return */
  (*size) = datatype->size;
  return (MPI_SUCCESS);
}
