/*
 *  $Id: type_ub.c,v 1.3 1994/06/07 21:22:40 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   type_ub.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: type_ub.c,v 1.3 1994/06/07 21:22:40 gropp Exp $";
#endif /* lint */

/*@
    MPI_Type_ub - Returns the upper bound of a datatype

Input Parameters:
. datatype - datatype (handle) 

Output Parameter:
. displacement - displacement of upper bound from origin, 
                             in bytes (integer) 
@*/
Int MPI_Type_ub ( MPI_Datatype  datatype, Int far *displacement)
{
	Int errno;
	if (MPIR_TEST_DATATYPE(MPI_COMM_WORLD,datatype) || 
	  	MPIR_TEST_ARG(displacement))
	{
		return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_TYPE_UB" );
	}
	/* Assign the ub and return */
	(*displacement) = datatype->ub;
	return (MPI_SUCCESS);
}
