/*
 *  $Id: cart_coords.c,v 1.9 1994/06/07 21:23:55 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   crt_coo.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Cart_coords - Determines process coords in cartesian topology given
                  rank in group

Input Parameters:
. comm - communicator with cartesian structure (handle) 
. rank - rank of a process within group of comm (integer) 
. maxdims - length of vector  coord in the calling program (integer) 

Output Parameter:
. coords - integer array (of size  ndims ) containing the cartesian coordinates of specified process (integer) 

@*/
Int MPI_Cart_coords ( MPI_Comm  comm, Int rank, Int maxdims, Int far *coords)
{
  Int i, ndims, far *dims, num_ranks;
  Int errno = MPI_SUCCESS;

  /* Check for valid arguments */
  if ( MPIR_TEST_COMM( comm, comm ) ||
	   ((comm->topology.type != MPI_CART)   && ((errno = MPI_ERR_TOPOLOGY) != 0))  ||
	   ((rank                <  0)          && ((errno = MPI_ERR_RANK) != 0))      ||
	   ((rank >= (comm->topology.tag.cart.nnodes))&&((errno = MPI_ERR_RANK) != 0)) ||
	   ((maxdims             <  1)          && ((errno = MPI_ERR_DIMS) != 0))      ||
       MPIR_TEST_ARG(coords) )
    return MPIR_ERROR( comm, errno, "Error in MPI_CART_COORDS" );

  /* Calculate coords */
  ndims     = comm->topology.tag.cart.ndims;
  dims      = comm->topology.tag.cart.dims;
  num_ranks = comm->topology.tag.cart.nnodes;
  for ( i=0; (i < ndims) && (i < maxdims); i++ ) {
    num_ranks = num_ranks / dims[i];
	coords[i]  = rank / num_ranks;
    rank   = rank % num_ranks;
  }

  return (errno);
}
