/*
 *  $Id: cart_get.c,v 1.4 1994/06/07 21:23:56 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   crt_get.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Cart_get - Retrieves Cartesian topology information associated with a 
               communicator

Input Parameters:
. comm - communicator with cartesian structure (handle) 
. maxdims - length of vectors  dims, periods , and  coords in the calling program (integer) 

Output Parameters:
. dims - number of processes for each cartesian dimension (array of integer) 
. periods - periodicity (true /false ) for each cartesian dimension (array of logical) 
. coords - coordinates of calling process in cartesian structure (array of integer) 

@*/
Int MPI_Cart_get ( MPI_Comm comm, Int maxdims, 
		   Int far *dims, Int far *periods, Int far *coords)
{
  Int i, num;
  Int far *array;
  Int errno = MPI_SUCCESS;

  /* Check for valid arguments */
  if (MPIR_TEST_COMM(comm,comm) ||
	  ((comm->topology.type != MPI_CART) && ((errno = MPI_ERR_TOPOLOGY) != 0)) )
    return MPIR_ERROR( comm, errno, "Error in MPI_CART_GET" );

  /* Get dims */
  num = comm->topology.tag.cart.ndims;
  array = comm->topology.tag.cart.dims;
  if ( dims != NULL )
    for ( i=0; (i<maxdims) && (i<num); i++ )
      (*dims++) = (*array++);

  /* Get periods */
  num = comm->topology.tag.cart.ndims;
  array = comm->topology.tag.cart.periods;
  if ( periods != NULL )
    for ( i=0; (i<maxdims) && (i<num); i++ )
      (*periods++) = (*array++);

  /* Get coords */
  num = comm->topology.tag.cart.ndims;
  array = comm->topology.tag.cart.position;
  if ( coords != NULL )
    for ( i=0; (i<maxdims) && (i<num); i++ )
      (*coords++) = (*array++);

  return (errno);
}
