/*
 *  $Id: cart_map.c,v 1.3 1994/06/07 21:23:57 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   crt_map.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Cart_map - Maps process to Cartesian topology information 

Input Parameters:
. comm - input communicator (handle) 
. ndims - number of dimensions of cartesian structure (integer) 
. dims - integer array of size  ndims specifying the number of processes 
  in each coordinate direction 
. periods - logical array of size  ndims specifying the periodicity specification 
  in each coordinate direction 
Output Parameter:
. newrank - reordered rank of the calling process; MPI_UNDEFINED if calling process 
  does not belong to grid (integer) 

@*/
Int MPI_Cart_map ( MPI_Comm comm_old, Int ndims, 
                   Int far *dims, Int far *periods, Int far *newrank)
{
  Int i;
  Int nranks = 1;
  Int rank;
  Int errno = MPI_SUCCESS;

  periods = periods;
  /* Check for valid arguments */
  if (MPIR_TEST_COMM(comm_old,comm_old) ||
	  ((ndims < 1)                 && ((errno = MPI_ERR_DIMS) != 0)) ||
	  ((newrank == NULL)           && ((errno = MPI_ERR_ARG) != 0))  ||
	  ((dims == NULL)              && ((errno = MPI_ERR_ARG) != 0))  )
    return MPIR_ERROR( comm_old, errno, "Error in MPI_CART_MAP" );
  
  /* Determine number of processes needed for topology */
  for ( i=0; i<ndims; i++ )
    nranks *= dims[i];

  /* Am I in this range? */
  MPI_Comm_rank ( comm_old, &rank );
  if ( rank < nranks )
    (*newrank) = rank;
  else
    (*newrank) = MPI_UNDEFINED;

  return (errno);
}
