/*
 *  $Id: graph_get.c,v 1.3 1994/06/07 21:24:03 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   gph_get.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Graph_get - Retrieves graph topology information associated with a 
                communicator

Input Parameters:
. comm - communicator with graph structure (handle) 
. maxindex - length of vector index in the calling program  (integer) 
. maxedges - length of vector edges in the calling program  (integer) 

Output Parameter:
. index - array of integers containing the graph structure (for details see 
  the definition of MPI_GRAPH_CREATE ) 
. edges - array of integers containing the graph structure 

@*/
Int MPI_Graph_get ( MPI_Comm comm, Int maxindex, Int maxedges, 
		    Int far *index, Int far *edges)
{
  Int i, num;
  Int far *array;
  Int errno = MPI_SUCCESS;

  if (MPIR_TEST_COMM(comm,comm) ||
	  ((comm->topology.type != MPI_GRAPH)   && ((errno = MPI_ERR_TOPOLOGY) != 0)) )
    return MPIR_ERROR( comm, errno, "Error in MPI_GRAPH_GET" );

  /* Get index */
  num = comm->topology.tag.graph.nnodes;
  array = comm->topology.tag.graph.index;
  if ( index != NULL )
    for ( i=0; (i<maxindex) && (i<num); i++ )
      (*index++) = (*array++);

  /* Get edges */
  num = comm->topology.tag.graph.nedges;
  array = comm->topology.tag.graph.edges;
  if ( edges != NULL)
    for ( i=0; (i<maxedges) && (i<num); i++ )
      (*edges++) = (*edges++);

  return (errno);
}
