/*
 *  $Id: graph_map.c,v 1.3 1994/06/07 21:24:04 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   gph_map.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Graph_map - Maps process to graph topology information

Input Parameters:
. comm - input communicator (handle) 
. nnodes - number of graph nodes (Integer) 
. index - Integer array specifying the graph structure, see  MPI_GRAPH_CREATE 
. edges - Integer array specifying the graph structure 

Output Parameter:
. newrank - reordered rank of the calling process; MPI_UNDEFINED if the 
calling process does not belong to graph (integer) 
 

@*/
Int MPI_Graph_map ( MPI_Comm comm_old, Int nnodes, 
		    Int far *index, Int far *edges, Int far *newrank)
{
  Int rank;
  Int errno = MPI_SUCCESS;

  if (MPIR_TEST_COMM(comm_old,comm_old) ||
	  ((nnodes   <  1)             && ((errno = MPI_ERR_ARG) != 0))  ||
      MPIR_TEST_ARG(newrank) || MPIR_TEST_ARG(index) ||
      MPIR_TEST_ARG(edges))
    return MPIR_ERROR( comm_old, errno, "Error in MPI_GRAPH_MAP" );
  
  /* Am I in this topology? */
  MPI_Comm_rank ( comm_old, &rank );
  if ( rank < nnodes )
    (*newrank) = rank;
  else
    (*newrank) = MPI_UNDEFINED;

  return (errno);
}
