
/****************************************************************
*                                                               *
*  pimpi.c                                                      *
*  Calculation of PI (numerical integration method)             *
*  MPI version                                                  *
*  Joerg Meyer       University of Nebraska at Omaha            *
*  11/15/94          Computer Science Department                *
*                                                               *
****************************************************************/

#include <stdio.h>
#include <stdlib.h>
// #include <sys/time.h>          // changed !!!
#include <mpi.h>

/****************************************************************
*                                                               *
*  compute_interval - numerical integration over                *
*                     part of interval                          *
*                                                               *
****************************************************************/
double compute_interval (Int myrank, Int ntasks, long intervals)
{
    double width, x, localsum;
    long j;

    width = 1.0 / intervals;	/* width of single stripe */
    localsum = 0.0;
    for (j = myrank; j < intervals; j += ntasks)
    {
//        if (!((j / ntasks) & 0x2000))
//            MPI_Win_yield ();
            
        x = (j + 0.5) * width;
        localsum += 4 / (1 + x * x);
    }
    return (localsum * width);	/* size of area */
}

// int main (argc, argv)
int MPI_main (int argc, LPPSTR argv)
{
    long intervals;
    Int myrank, ranksize;
    double pi, di;
    Int i;
    MPI_Status status;
    double t1, t2, time;

    MPI_Init (&argc, &argv);       /* initialize MPI system */
    MPI_Comm_rank (MPI_COMM_WORLD, &myrank);    /* my place in MPI system */
    MPI_Comm_size (MPI_COMM_WORLD, &ranksize);  /* size ofMPI system */

    if (myrank == 0)               /* I am the parent/master */
    {
        printf ("Calculation of PI by numerical Integration\n");
//        intervals = atol (argv[1]);
//        printf ("%ld intervals used\n", intervals);
	printf ("Number of intervals: ");
	scanf ("%ld", &intervals);
    }

    MPI_Barrier (MPI_COMM_WORLD);  /* make sure all MPI tasks are running */
    if (myrank == 0)               /* I am the parent/master */
    {
	t1 = MPI_Wtime ();
/* distribute parameter */
	printf ("Master: Sending # of intervals to MPI-Process ");
        for (i = 1; i < ranksize; i++)                    
        {
            printf ("%ld - ", i);
            MPI_Send (&intervals, 1, MPI_LONG, i, 98, MPI_COMM_WORLD);
        }
        printf ("\n");
    }
    else	/* I am a child/slave */
/* receive parameters */
        MPI_Recv (&intervals, 1, MPI_LONG, 0, 98, MPI_COMM_WORLD, &status);

/* compute my portion of interval */
    pi = compute_interval (myrank, ranksize, intervals);

    MPI_Barrier (MPI_COMM_WORLD);
    if (myrank == 0)	/* I am the parent/master */
/* collect results, add up, and print results */
    {
	printf ("Master: Collecting sum from MPI-Process ");
        for (i = 1; i < ranksize; i++)
        {
            printf ("%ld - ", i);
            MPI_Recv (&di, 1, MPI_DOUBLE, i, 99, MPI_COMM_WORLD, &status);
            pi += di;
        }            
        printf ("\n");
	t2 = MPI_Wtime ();
	time = t2 - t1;
        printf ("Pi estimation: %14.12lf\n", pi);
	printf ("%ld tasks used - Execution time: %.2lf sec\n", 
		ranksize, time);
//	printf ("Clock resolution: %.4lf sec\n", MPI_Wtick());
    }
    else	/* I am a child/slave */
/* send my result back to parent/master */
        MPI_Send (&pi, 1, MPI_DOUBLE, 0, 99, MPI_COMM_WORLD);

    MPI_Finalize ();    
    return 0;	// change !!!
}


