#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <stdarg.h>
#include <stdio.h>
#include <socketlib.h>
#include <channel.h>

Channel *NewInChan( const char * server_name, int portnum )
{
  Channel * hchan;
  hchan = (Channel *) malloc (sizeof (Channel));
  if (hchan==0)
  {
    fprintf( stderr, "NewInChan: cannot get memory\n" );
    exit( -1 );
  }
  hchan->k = ip_in;
  hchan->partner_name = (char *) malloc( strlen( server_name ) + 1 );
  if (hchan->partner_name==0)
  {
    fprintf( stderr, "NewInChan: cannot get memory\n" );
    exit( -1 );
  }
  strcpy( hchan->partner_name, server_name );
  hchan->partner_portnum = portnum;
  hchan->connected = 0;

  return hchan;
}

Channel *NewOutChan( int portnum )
{
  Channel * hchan;
  hchan = (Channel *) malloc (sizeof (Channel));
  if (hchan==0)
  {
    fprintf( stderr, "NewOutChan: cannot get memory\n" );
    exit( -1 );
  }
  hchan->k = ip_out;
  hchan->partner_portnum = portnum;
  hchan->connected = 0;

  return hchan;
}

void ConnectInChan( Channel * cchan )
{
  while((cchan->fd = connectTCP( cchan->partner_name, cchan->partner_portnum ))<=0)
  {
    (void) sleep(1);
  }
  cchan->connected = 1;
}

void ConnectOutChan( Channel * schan )
{
  int alen, mfd;
  struct sockaddr_in sin;
  alen = sizeof( struct sockaddr_in );
  mfd = passiveTCP( schan->partner_portnum );
  schan->fd = accept( mfd, (struct sockaddr *) &sin, &alen );
  close( mfd );
  schan->connected = 1;
}

void TLevelChanIn( Channel* ichan, void * cp, int count )
{
  int hcount;

  if (ichan->connected == 0)
  {
    ConnectInChan( ichan );
  }

  hcount = read( ichan->fd, cp, count );
  if ( hcount == -1 )
  {
    perror("NaiveIn: read");
    exit( -1 );
  }
  if ( hcount == 0 )
  {
    fprintf( stderr, "NaiveIn: lost connection\n" );
    exit( -1 );
  }
  if ( hcount != count )
  {
    fprintf( stderr, "NaiveIn: expected %d bytes, got %d bytes\n",
                     count, hcount );
    exit( -1 );
  }
}

void TLevelChanOut( Channel * ochan, void * cp, int count )
{
  int hcount;

  if (ochan->connected == 0)
  {
    ConnectOutChan( ochan );
  }  

  hcount = write( ochan->fd, cp, count );
  if ( hcount == -1 )
  {
    perror("NaiveOut: write");
    exit( -1 );
  }
  if ( hcount != count )
  {
    fprintf( stderr, "NaiveOut: write with %d bytes, only %d bytes written\n",
                     count, hcount );
    exit( -1 );
  }
}

void ChanIn( Channel *c, void *cp, int count )
{
  static char dummy = 'x';

  int hcount;

  if ( c->k == ip_out )
  {
    fprintf( stderr, "ChanIn: channel configured for output\n" );
    exit( -1 );
  }  

#ifdef DEBUG
  printf("reading %d bytes from socket #%d\n",count,*c);
#endif

  TLevelChanIn( c, &hcount, sizeof( int ) );

  if (ntohl(hcount) != count)
  {
    fprintf( stderr, "ChanIn: Size mismatch, need %d bytes, got %d bytes\n",
                     count, (int) ntohl(hcount) );
    exit( -1 );
  }

  TLevelChanIn( c, cp, count );
  TLevelChanOut( c, &dummy, 1 );
}

void ChanOut( Channel *c, void *cp, int count )
{
  static char dummy;
  int ncount;
  ncount = htonl( count );

  if ( c->k == ip_in )
  {
    fprintf( stderr, "ChanOut: channel configured for input\n" );
    exit( -1 );
  }  

#ifdef DEBUG
  printf("writing %d bytes to socket #%d\n",count,*c);
#endif

  TLevelChanOut( c, &ncount, sizeof( int ) );
  TLevelChanOut( c, cp, count );
  TLevelChanIn( c, &dummy, 1 );
}

unsigned char ChanInChar( Channel *c )
{
  char h;
  ChanIn( c, &h, sizeof( unsigned char ) );
  return h;
}

int ChanInInt( Channel *c )
{
  int h;
  ChanIn( c, &h, sizeof( int ) );
  return ( ntohl( h ) );
}

void ChanOutChar( Channel *c, unsigned char ch )
{
  ChanOut( c, &ch, 1 );
}

void ChanOutInt( Channel *c, int n )
{
  int nn;
  nn = htonl( n );
  ChanOut( c, &nn, sizeof( int ) );
}

int ProcAlt( Channel * c1, ... )
{
  Channel *ca[20];
  Channel *cx;
  fd_set readfds, writefds, exeptfds;
  int cnum, i, h;
  va_list ap;

  FD_ZERO( &readfds );
  FD_ZERO( &writefds );
  FD_ZERO( &exeptfds );

  cnum = 0;

  va_start( ap, c1 );

  cx = c1;

  while (cx != 0)
  {
    if (cx->k != ip_in)
    {
      fprintf( stderr, "ProcTimerAlt: cannot read from output-Channel\n");
      exit( -1 );
    }
    if (!cx->connected)
    {
      ConnectInChan( cx );
    }
    FD_SET( cx->fd, &readfds );
    ca[cnum++] = cx;
    cx = va_arg( ap, Channel* );
  }

  va_end( ap );

  h = select( 20, &readfds, &writefds, &exeptfds, NULL );

  if (h==0) return -1;   /* timeout */

  i=0;

  while ( ! FD_ISSET( ca[i]->fd, &readfds ) )
  {
    i += 1;
  }

  return i;
}







