#ifndef _CHANNEL_H
#define _CHANNEL_H

enum channel_kind { ip_in, ip_out };

typedef struct
{
  enum channel_kind k;
  int connected;
  char * partner_name;
  int partner_portnum;
  int fd;
} Channel;


Channel *NewInChan( const char * server_name, int portnum );

Channel *NewOutChan( int portnum );

/* Channel *ChanAlloc( const char * cname ); */
/* void ChanInitialize( void ); */
/* void NaiveIn( int fd, void* cp, int count ); */
/* void NaiveOut( int fd, void* cp, int count ); */

void TLevelChanIn( Channel *c, void *cp, int count );

void TLevelChanOut( Channel *c, void *cp, int count );

void ChanIn( Channel *c, void *cp, int count );

void ChanOut( Channel *c, void *cp, int count );


unsigned char ChanInChar( Channel *c );

int ChanInInt( Channel *c );

void ChanOutChar( Channel *c, unsigned char ch );

void ChanOutInt( Channel *c, int n );

int ProcAlt( Channel * c1, ... );

#define DirectChanIn      ChanIn
#define DirectChanOut     ChanOut
#define DirectChanInChar  ChanInChar
#define DirectChanInInt   ChanInInt
#define DirectChanOutChar ChanOutChar
#define DirectChanOutInt  ChanOutInt

#endif _CHANNEL_H


