#include <stdio.h>
#include <process.h>
#include <channel.h>
#include <misc.h>

#define sumupjob 1
#define terminate 2

static int lower;
static int upper;
static int act;
static int jsize;

static Channel *in_chan[2];
static Channel *out_chan[2];

static int pending[2];


void fork_job( int i )
{
  int n1, n2;

  n1 = act + 1;
  n2 = n1 + jsize -1;
  if (n2>upper)
  {
    n2 = upper;
  }
  act = n2;

  printf("forking job(%d,%d) to worker #%d\n",n1,n2,i);

  ChanOutChar( out_chan[i], sumupjob );
  ChanOutInt( out_chan[i], n1 );
  ChanOutInt( out_chan[i], n2 );

  pending[i] = 1;
}

int work_to_do( void )
{
  return (act<upper);
}

double ChanInDouble( Channel* c )
{
  char hs[25];
  double hd;
  ChanIn( c, hs, 25 );
  sscanf( hs, "%le", &hd );
  return hd;
}

int jobs_pending()
{
  return (pending[0] || pending[1]);
}

int main()
{

  int t, i;

  double total;

  printf("*** farmer ***\n");

  in_chan[0]  = (Channel *) get_param(3);
  out_chan[0] = (Channel *) get_param(4);
  in_chan[1]  = (Channel *) get_param(5);
  out_chan[1] = (Channel *) get_param(6);

  lower = 1;
  upper = 1000000;
  act   = 0;
  jsize = 100000;

  printf("calculating Sum[ 1/i, {i,%d,%d}] with two workers\n",lower,upper);

  t = ProcTime();

  pending[0] = 0;
  pending[1] = 0;

  if (work_to_do())
  {
    fork_job(0);
  }

  if (work_to_do())
  {
    fork_job(1);
  }

  while (jobs_pending())
  {
    i = ProcAlt( in_chan[0], in_chan[1], NULL  );
    switch (i)
    {
       case 0 : case 1 :
       {
         printf("getting result from worker #%d\n", i );
         total += ChanInDouble( in_chan[i] );
         pending[i]=0;
         if (work_to_do())
	 {
           fork_job(i);
         }
       }
    }
  }

  t = ProcTime() - t;

  ChanOutChar( out_chan[0], terminate );
  ChanOutChar( out_chan[1], terminate );

  printf("Sum[ 1/i, {i,%d,%d}] = %2.13f\n",lower,upper,total);
  printf("elapsed time: %3.3f seconds\n",((double)t)*64.0e-6);

  return( 0 );

}


