#include <stdio.h>
#include <channel.h>
#include <misc.h>

#define sumupjob 1
#define terminate 2

void ChanOutDouble( Channel* c, double d )
{
  char h[25];
  sprintf(h,"%.18E",d);
  ChanOut( c, &h, 25 );
}

int main(int argc, char ** argv )
{

  register double h;
  register int i;

  int j;

  int n0;
  int n1;

  Channel * in_chan;
  Channel * out_chan;

#ifdef INFO
  printf("*** worker ***\n");
#endif

  /* get channels */
  in_chan  = (Channel *) get_param(1);
  out_chan = (Channel *) get_param(2);


  j = ChanInChar( in_chan );

  while ( j == sumupjob ) {

  /* read input parameters */

  n0 = ChanInInt(in_chan);

#ifdef INFO
  printf("--> start value = %d\n", n0 );
#endif

  n1 = ChanInInt(in_chan);

#ifdef INFO
  printf("--> end value   = %d\n", n1 );
#endif

  /* calculate sum */

  h  = 0.0;

  for ( i = n1; i >= n0 ; i-- )
  {
    h += ( 1.0 / (double) i );
  }

  /* write output */

#ifdef INFO
  printf("--> result = %2.13f\n",h);
#endif

  ChanOutDouble( out_chan, h );

  j = ChanInChar( in_chan );

  }

  return 0;

}








